<?php
/*
Gibbon: the flexible, open school platform
Founded by Ross Parker at ICHK Secondary. Built by Ross Parker, Sandra Kuipers and the Gibbon community (https://gibbonedu.org/about/)
Copyright © 2010, Gibbon Foundation
Gibbon™, Gibbon Education Ltd. (Hong Kong)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

use Gibbon\Forms\Form;
use Gibbon\Forms\DatabaseFormFactory;

if (isActionAccessible($guid, $connection2, '/modules/School Admin/alertLevelSettings.php') == false) {
    // Access denied
    $page->addError(__('You do not have access to this action.'));
} else {
    // Proceed!
    $page->breadcrumbs
        ->add(__('Student Alert Settings'), 'alertLevelSettings.php')
        ->add(__('Add Type'));

    $editLink = '';
    if (isset($_GET['editID'])) {
        $editLink = $session->get('absoluteURL').'/index.php?q=/modules/School Admin/alertType_edit.php&gibbonAlertTypeID='.$_GET['editID'];
        $page->return->setEditLink($editLink);
    }
    $page->return->setEditLink($editLink);

    $form = Form::create('alertType', $session->get('absoluteURL').'/modules/'.$session->get('module').'/alertType_addProcess.php');
    $form->setFactory(DatabaseFormFactory::create($pdo));
    $form->addHiddenValue('address', $session->get('address'));

    $row = $form->addRow();
        $row->addLabel('name', __('Name'))->description(__('Must be unique.'));
        $row->addTextField('name')->required()->maxLength(60);

    $row = $form->addRow();
        $row->addLabel('tag', __('Tag'));
        $row->addTextField('tag')->maxLength(2)->required();

    $row = $form->addRow();
        $row->addLabel('description', __('Description'));
        $row->addTextArea('description')->setRows(4);

    $row = $form->addRow();
        $row->addLabel('adminOnly', __('Admin Only'))->description(__('Determines whether this type of alert requires full access to Manage Student Alerts.'));
        $row->addYesNo('adminOnly')->selected('N');

    $row = $form->addRow();
        $row->addLabel('useLevels', __('Alert Levels'))->description(__('Enables this type of alert to use low, medium, and high alert levels. This determines the alert colour.'));
        $row->addYesNo('useLevels')->selected('N');

    $form->toggleVisibilityByClass('noLevels')->onRadio('useLevels')->whenNot('Y');

    $row = $form->addRow()->addClass('noLevels');
        $row->addLabel('color', __('Font/Border Colour'))->description(__('Click to select a colour.'));
    	$row->addColor('color');

    $row = $form->addRow()->addClass('noLevels');
        $row->addLabel('colorBG', __('Background Colour'))->description(__('Click to select a colour.'));
        $row->addColor('colorBG');

    $row = $form->addRow();
        $row->addFooter();
        $row->addSubmit();

    echo $form->getOutput();
}
